﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Delegalt_tetel
{
    class Program
    {
        delegate bool Ttul(int x);
        static bool eldöntés(List<int> lista, Ttul T)
        {
            int i = 0;
            while (i < lista.Count && !T(lista[i]))
                i++;
            return i < lista.Count;
        }
        static int megszámol(List<int> lista, Ttul T)
        {
            int db = 0;
            foreach (int elem in lista)            
                if (T(elem)) db++;
            return db;
        }
        static List<int> kiválogatás(List<int> lista, Ttul T)
        {
            List<int> er = new List<int>();
            foreach (int elem in lista)
                if (T(elem)) er.Add(elem);
            return er;
        }
        static bool kettővelosztható(int x) //delegáltnak megfelelő függvény
        {
            return x % 2 == 0;
        }
        static bool öttelosztható(int x)  //delegáltnak megfelelő függvény
        {
            return x % 5 ==0;
        }
        static bool hárommalosztható(int x)  //delegáltnak megfelelő függvény
        {
            return x % 3 == 0;
        }
        static void Main(string[] args)
        {
            List<int> lista = new List<int>() { 2,4,5,10,34,35,20,25};
            if (eldöntés(lista, kettővelosztható))
                Console.WriteLine("Van köztük kettővel osztható");
            else
                Console.WriteLine("Nincs kettővel osztható");

            if (eldöntés(lista, hárommalosztható))
                Console.WriteLine("Van köztük hárommal osztható");
            else
                Console.WriteLine("Nincs hárommal osztható");

            if (eldöntés(lista, öttelosztható))
                Console.WriteLine("Van köztük öttel osztható");
            else
                Console.WriteLine("Nincs öttel osztható");
            Console.WriteLine();
            Console.WriteLine("5-tel oszthatóak száma: {0}", megszámol(lista, öttelosztható));
            Console.WriteLine("2-vel oszthatóak száma: {0}", megszámol(lista, kettővelosztható));
            Console.WriteLine("3-mal oszthatóak száma: {0}", megszámol(lista, hárommalosztható));
            Console.WriteLine();
            Console.Write("Kettővel oszthatók:");
            foreach (int elem in kiválogatás(lista, kettővelosztható))
                Console.Write(elem + ",");
            Console.WriteLine();
            Console.Write("hárommal oszthatók:");
            foreach (int elem in kiválogatás(lista, hárommalosztható))
                Console.Write(elem + ",");
            Console.WriteLine();
            Console.Write("Öttel oszthatók:");
            foreach (int elem in kiválogatás(lista, öttelosztható))
                Console.Write(elem + ",");
            Console.WriteLine();

        }
    }
}
