function getOffset(obj) {
	if (typeof obj == "string")
		obj = document.getElementById(obj)

	var left = 0, top = 0;
	while (obj) {
		left += parseInt(obj.offsetLeft);
		top += parseInt(obj.offsetTop);
		obj = obj.offsetParent;
	}

	return {left: left, top: top};
}

function changeHeight() {
	document.getElementById("tbody").style.height = (getOffset("footer").top - getOffset("tbody").top) + "px";
}

function loadPage(pageName) {
	var tbody = document.getElementById("tbody");
	document.location.href = pageName + ((tbody.scrollTop > 0) ? "?" + tbody.scrollTop : "");
}

function loadMeth(url) {
	var methWin = window.open(url, "Mdszertan", "width=700, height=540, resizable=no, scrollbars=yes");
	methWin.focus();
}

function initPage() {
	var tableDiv = document.getElementById("tbody");
	if (tableDiv) {
		var table = tableDiv.getElementsByTagName("table")[0];
		var rows = table.tBodies[0].rows.length;
		
		for (var r = 0; r < rows; r++) {
			// a pratlan sorok "odd", pros sorok "even" stlust kapnak
			table.tBodies[0].rows[r].className += (r % 2 == 0) ? "odd" : " even";
					
			// kivltjuk a tr:hover-t kt egyszer fggvnnyel
			table.tBodies[0].rows[r].onmouseover = function() { this.className += " activerow"; }
			table.tBodies[0].rows[r].onmouseout  = function() { this.className = this.className.replace(/activerow/g, ""); }
		}
	}
	
	var icons = document.getElementById("icons");
	if (icons) {
		var iconLinks = icons.getElementsByTagName("a");
		for (var i = 0, linksNum = iconLinks.length; i < linksNum; i++) {
			var link = iconLinks[i];
			if (link.className == "icon") {
				if (link.parentNode.getElementsByTagName("div").length == 0)
					link.className += " inact";
			}
		}
	}
	
	var tb_prnt = document.getElementById("tb_prnt");
	if (tb_prnt) {
		tb_prnt.onclick = function() { window.print(); return false; }
	}
	
	var prevpage = document.getElementById("prevpage");
	if (prevpage) {
		if (RegExp(/#$/).test(prevpage.href)) {
			prevpage.className += " inact";
			prevpage.onclick = function() { return false; }
		} else {
			prevpage.onclick = function() { loadPage(prevpage.href); return false; }
		}
	}
	
	var nextpage = document.getElementById("nextpage");
	if (nextpage) {
		if (RegExp(/#$/).test(nextpage.href)) {
			nextpage.className += " inact";
			nextpage.onclick = function() { return false; }
		} else {
			nextpage.onclick = function() { loadPage(nextpage.href); return false; }
		}
	}

	var pages = document.getElementById("pages");
	if (pages) {
		var links = pages.getElementsByTagName("a");
		for (var l = 0; l < links.length; l++)
			links[l].onclick = function() { loadPage(this.href); return false; }
	}

	var footer = document.getElementById("footer");
	if (footer) {
		footer.className += " show";
	 	changeHeight();
		window.onresize = changeHeight;
	}

	var urlparam = location.href.split("?");
	if (urlparam[1] > 0)
		tableDiv.scrollTop = urlparam[1];
	
	var IEpos = navigator.userAgent.indexOf("MSIE");
	if (IEpos > -1) {
		var IEver = parseFloat(navigator.userAgent.substring(IEpos + 5));
		if (IEver < 7) {
			var iconList = document.getElementById("icons");
			
			for (var i = 0; i < iconList.children.length; i++) {
				iconList.children(i).onmouseover = function() { this.className += " hover"; }
				iconList.children(i).onmouseout = function() { this.className = this.className.replace(/hover/g, ""); }
			}
		}
	}	
}

window.onload = initPage;