
if ( typeof(ml) == "undefined" ) {ml={};};
if ( typeof(ml.ajax) == "undefined" ) {ml.ajax={};};

ml.ajax.funcComplete = [];

/**
 * options:
 * 	route		:	route
 * 	target		:	target element (jQuery selector)
 * 	parameters	:	POST parameters
 * 	formid		:	id of the posting form
 * 	isReplace	:	true -> the target element will be replaced
 * 	isRawInsert	:	true -> the insert won't run scripts
 * 	onSuccess	:	callback on success
 * 	onComplete	:	callback on complete
 * 	onError		:	callback on error
 *
 */
ml.ajax.getServer = function(options) {
//		target, route, parameters_vs_formid, callback, isReplace, isRawInsert) {
	if ( options 					== undefined )	throw 'options is undefined!';
	if ( options.route 			== undefined )	throw 'options.route is missing!';
	if ( options.target			== undefined ) 	options.target	 	= false;
	if ( options.isReplace		== undefined ) 	options.isReplace 	= false;
	if ( options.isRawInsert	== undefined ) 	options.isRawInsert = false;
	if ( options.parameters		== undefined ) 	options.parameters	 = {};

	if ( !util.readCookie('mlsession') && ml.State.mlsession ) options.parameters.mlsession = ml.State.mlsession;
	if ( ml && ml.State && ml.State.adminsalt ) options.parameters.adminsalt = ml.State.adminsalt;

	// paraméterek kódolása
	postParameters = j.param(options.parameters);
	if ( typeof(options.formid) == 'string' ) {
		formParameters = j('#'+options.formid).serialize();
		postParameters = postParameters+'&'+formParameters;
	}

	if ( typeof(ml.ajax.Preloader) == "undefined" ) ml.ajax.Preloader = new ml.ajax.DefaultPreloader(); // preloader

	ml.ajax.Preloader.show();
	if (typeof (options.noAudit) == 'undefined' || !options.noAudit) {
		ml.ajax.auditMedian();
		ml.ajax.auditGemius();
		ml.ajax.refreshAdverts();
		ml.ajax.SiteStat();
	}
	try{
		jQuery.ajax({
			type		: "POST"
			,url		: options.route
			,cache		: false
			,dataType	: 'json'
			,data		: postParameters
			,success	: function (data, textStatus) {
								if ( options.onSuccess != undefined ) {
									if ( typeof(options.onSuccess) == 'function' ) {
										if ( options.onSuccess(data, textStatus) === false ) return;
									}else if ( typeof(options.onSuccess) == 'object' ) {
										if (options.onSuccess.delayed) {
											setTimeout(function(){options.onSuccess.fn.call(options.onSuccess.scope, data, textStatus);}, 1 );
										}else{
											options.onSuccess.fn.call(options.onSuccess.scope, data, textStatus);
										}
									}
								}
								if ( data.commands != undefined ) {
									ml.ajax.ajaxCommands.parseCommands(data.commands);
								}
								if (	data['return'] != undefined &&
										typeof(data['return'])=='string' ) {
									//console.log(target);
									if (options.target) {

										// CKEDITOR törlése mielőtt kinyírjuk a DOM-ot
										if ( typeof(options.target) == 'string') {
											var cks = j(options.target+' .ckeditor');
											for(var i=0;i<cks.length;i++) {
												CKEDITOR.destroy(cks[i].id);
											}
										}
										if ( options.isReplace ){
											if ( options.isRawInsert ) {
												alert('Ez a fajta hívás nem támogatott');
											}else{
												jQuery(options.target).replaceWith(data['return']);
											}
										}else{
											if ( options.isRawInsert ) {
												jQuery(options.target).each(function(index, elem){elem.innerHTML = data['return'];});
											}else{
												jQuery(options.target).html(data['return']);
											}
										}
										if (typeof(j.fn.tipsy) == 'function') {
									   	j('.tooltip').tipsy({
									   		title: 'tooltip',
									   		fade: true
									   	}).removeClass('tooltip');
									   }
									}
								}

							}
			,error		: function (XMLHttpRequest, textStatus, errorThrown) {
								if ( options.onError != undefined ) {
									if ( options.onError(XMLHttpRequest, textStatus, errorThrown) === false ) return;
								}
								if ( XMLHttpRequest.status != 200 ) {
									alert( 'Végzetes hiba történt ('+XMLHttpRequest.status+' '+textStatus+' '+XMLHttpRequest.responseText+')');
								}else{
									// HTTP 200
									//console.log(errorThrown);
									alert( 'Végzetes hiba történt ('+XMLHttpRequest.status+' '+textStatus+')');
								}
							}
			,complete	: function(XMLHttpRequest, textStatus) {

								ml.ajax.Preloader.hide();

								if ( typeof(options.scrollTop) == "undefined" ) options.scrollTop = false;
								if ( options.scrollTop == false ) {
									// do nothing
								}else{
									jQuery('html, body').animate({scrollTop:0}, options.scrollTop, 'swing');
								}

								if ( options.onComplete != undefined ) {
									options.onComplete(XMLHttpRequest, textStatus);
								}
								if ( ml.ajax.funcComplete.length>0 ) {
									var l = ml.ajax.funcComplete.length;
									for(var i=0; i<l; i++) {
										var f = ml.ajax.funcComplete[i];
										f(XMLHttpRequest, textStatus);
									}
								}
	//							ml.convertA(); // a tag to ajax call converter!
							}
		});
	}catch(err){
		console.log(err);
		ml.ajax.Preloader.hide();
	}
};

ml.ajax.onComplete = function( func ) {
	ml.ajax.funcComplete[ml.ajax.funcComplete.length] = func;
};

ml.ajax.auditGemius = function(){
	if ( typeof(GEMIUS_ID) == 'undefined' ) return;
	gemius_hit(GEMIUS_ID);
}

ml.ajax.auditMedian = function() {
	if ( typeof(WEBAUDIT_UC_AJAX) == 'undefined' ) return;
	var uc = WEBAUDIT_UC_AJAX;
	/* medianwebaudit.js a kapott etalon kód, ebből kivágva a frissítéshez szükséges kód */
	var same =  Math.floor(Math.random()*1000000);
	var wa=new WEBAUDIT();
	var felbontas = "";
	var wa_url = "@u=";
	var wa_referrer = "@r=";

	if(wa.WACID==null)
	{
	  wa.WACID=wa.generateID('A');
	  wa.setCookie(wa.WACIDName,wa.WACID,wa.getTopDomain(wa.getDomain(document.URL)));
	}

	same = same + "@c=" + wa.WACID;
	if(screen) felbontas='@s='+screen.width+'x'+screen.height;
	if(document.referrer) wa_referrer=wa_referrer+document.referrer;
	if(document.URL) wa_url=wa_url+document.URL;
	same = same + felbontas + wa_url + wa_referrer;
	if (!document.getElementById("MedianContainer")) {
		mc = document.createElement("div");
		mc.id = "MedianContainer";
		mc.style.display = "none";
		document.body.appendChild(mc);
	}
	mc = document.getElementById("MedianContainer");
	mc.innerHTML = '<img style="position:absolute;top:-100px;left:-100px" src="http://audit.median.hu/cgi-bin/track.cgi?uc='+uc+'&dc=1&ui='+same+'" width="1" height="1">';
}

ml.ajax.SiteStat = function(){
	if ( typeof(MLSTATCODE) == 'undefined' ) return;
	jQuery('#MLSTATIMG').attr('src', '/stat/'+MLSTATCODE+'/'+Math.random());
}

ml.ajax.refreshAdverts = function() {
	j('.ml-advert-ajax-refresh iframe').each(function(i, f) {
//		console.log(f.src);
		f.src = f.src;
	});
}

ml.ajax.refreshAdverts = function() {
	j('.ml-advert-ajax-refresh iframe').each(function(i, f) {
//		console.log(f.src);
		f.src = f.src;
	});
}