
/**
 * A site oldali pager onclick eseményeit kezeli
 * 
 * @param {int} pagerid
 * @param {string} formatstring
 * @param {int} page
 * @param {string} target
 */
ml.helper.pagerSubmit = function(pagerid, formatstring, page, target) {
	if ( pagerid ) page = $('#ml-pager-page-'+pagerid).val();
	if ( !target ) target = '#ml-content';
	ml.site.getServer(target, formatstring.replace('%d', page));
};


/**
 * A site oldali commentpager onclick eseményeit kezeli
 * 
 * @param {int} content_type
 * @param {string} content_id
 * @param {int} page
 */
ml.helper.commentpagerSubmit = function(EntityID, page, _class, EntityLink) {
	var target = '#ml-comments-'+EntityID;
	var params = {
		EntityID			: EntityID
		,Page				: page
		,Class			: _class
		,EntityLink		: EntityLink
	};
	ml.site.getServer(target, '/comment/get', params);
};

ml.helper.charCounter = function(selector, maxchars) {
	var value = $(selector).val();
	if ( value.length>maxchars ) {
		$(selector).val( value.substring(0, maxchars) );
		alert('Maximum '+maxchars+' karakter lehet!');
	}else{
		var rest = maxchars - value.length;
		$(   $(selector).next().children()[0]   ).html(rest);
	}
};