/**
 * Gadget.Menubox, Mainmenu menükezelése
 */

ml.menu.openSubmenu = function(gadgetid, menuid, parentid) {
	$('#ml-menu-bucket-'+gadgetid+'-'+parentid).hide();
	$('#ml-menu-bucket-'+gadgetid+'-'+menuid).show();
};

ml.menu.closeSubmenu = function(gadgetid, menuid, parentid) {
	$('#ml-menu-bucket-'+gadgetid+'-'+menuid).hide();
	$('#ml-menu-bucket-'+gadgetid+'-'+parentid).show();
};

ml.menu.select = function(menu) {
//	console.log('ml.menu.select');
//	console.log(menu);
	var jmenu = null;
	if ( typeof(menu) == "string" ) {
		var m = menu.match(/^\/([^\/]+)\/(\d+).*$/);
		if (m) {
			var menuid = 'ml-menu-'+m[2];
			if ( $('#'+menuid).length == 1 ) {
				jmenu = $('#'+menuid);
			}
		}
	}else if ( typeof(menu) == "object" ) {
		if ( $(menu.parentNode).hasClass("ml-menu-item") ) {
			// menu selection megváltoztatása
			jmenu = $(menu.parentNode);
		}
	}
	if ( jmenu ) {
		// Ezt a menüt kell kiválasztani!
		jbucket = jmenu.parent().parent(); // ez a menühöz tartozó bucket
		jcontainer = jbucket.parent(); // ez a bucketeket tartalmazó div
		jcontainer.children().hide();
		jbucket.show();
		$(".ml-menu-item-selected").removeClass("ml-menu-item-selected");
		jmenu.addClass("ml-menu-item-selected");
	}
};

ml.menu.horizontalslide = function() {
	var menubox = j(j('.ml-menu-horizontal')[0]);
	var mwidth = menubox.width();
	var bucket = menubox.children(':visible');
	var width = 0;
	j(bucket).find('.ml-menu-item').each(function(i, item){
		width += j(item).width();
	});
	if (width < mwidth) {
		return; // nem piszkáljuk, elfér
   }
	// buttonok felvétele
	var bwidth = 10;
	var bl = j('<div>');
	bl.css('width', bwidth);
	bl.css('float', 'left');
	var br = j('<div>');
	br.css('width', bwidth);
	br.css('float', 'right');
	bucket.prepend(bl);
	bucket.append(br);
	bucket.find('dl').width(width-2*bwidth);
		
}
