/**
 * ml - Core library for ML site pages
 */
ml.site = {};

ml.site.route = false; // tartalmazza az ajax route-ot content esetén

/**
 * 
 * @param {string} target
 * @param {string} route
 * @param {object_vs_string} parameters_vs_formid
 * @param {function} callback
 */
ml.site.getServer = function(target, route, parameters_vs_formid, callback, isReplace, isRawInsert, scrollTop) {
	var formid = false;
	if ( typeof(parameters_vs_formid) == 'string' ) {
		formid = parameters_vs_formid;
		parameters_vs_formid = {};
	}
	ml.ajax.getServer({
		route		: route
		,target		: target
		,parameters : parameters_vs_formid
		,formid		: formid
		,onSuccess	: callback
		,isReplace	: isReplace
		,isRawInsert: isRawInsert
		,scrollTop  : scrollTop
//		,onComplete	: ml.site.convertA
	});
	return;

};

/**
 * A tartalom betöltése a #ml-content div-be
 * Ha paraméterek nélkül van meghívva, akkor az ekvivalens egy GET hívásal (route), és bekerül a historyba
 * @param {string} route
 * @param {object_vs_string} parameters_vs_formid
 * @param {function} callback
 */
ml.site.getContent = function(route, parameters_vs_formid, callback, scrollTop) {
	if ( parameters_vs_formid == null ) {
		// history
		$.history.add(route);
	}
	ml.site.getContent_do(route, parameters_vs_formid, callback, scrollTop);
};

/**
 * A tartalom betöltése a #ml-content div-be
 * @param {string} route
 * @param {object_vs_string} parameters_vs_formid
 * @param {function} callback
 */
ml.site.getContent_do = function(route, parameters_vs_formid, callback, scrollTop) {
	ml.site.route = route;
	ml.site.getServer('#ml-content', route, parameters_vs_formid, callback, false, true, scrollTop);
};

ml.site.getRoute = function() {
	if ( ml.site.route ) return ml.site.route;
	return window.location.pathname+window.location.search;
};

/**
 * A tartalom betöltése az adott gadget-be
 */
ml.site.getGadget = function(gadgetid, route, parameters_vs_formid, callback) {
	ml.site.getServer('#ml-gadget-'+gadgetid, route, parameters_vs_formid, callback);
};

/**
 * Az "a" tag alapján készít ajax hívásokat
 * $("a.ajax").removeClass("aja").click(function(){ ml.getA(this);});
 */
ml.site.convertA = function() {
	if ( j.mobile ) {
		// jquery mobile doesn't use this
		return;
	}
	return; // nincs már AJAX hívás
	j("a.ajax").removeClass("ajax").click(function(){ 
		var p = this.pathname;
		if ( p[0] != '/') p='/'+p; // IE miatt
		ml.site.getContent(p, null, function(){
			// request callback function
		});
		ml.menu.select(this);
		return false;
	});
};

ml.site.redirectLogin = function() {
	var route = ml.site.getRoute();
	var redirect = window.location.hostname+route;
	var url = 'http://'+ml.State.defaultdomain+'/login/site?redirect='+encodeURIComponent(redirect);
	window.location = url;
};

ml.site.redirectLogout = function() {
	var route = ml.site.getRoute();
	var redirect = window.location.hostname+route;
	var url = 'http://'+ml.State.defaultdomain+'/login/logout?redirect='+encodeURIComponent(redirect);
	window.location = url;
};